#include <bits/stdc++.h>
#define ll long long
#define MAXN 100010
using namespace std;
ll n,s,a[MAXN];
struct seg_tree
{
    vector<ll> st;
    void Init()
    {
        s=1;
        while (s<n)
            s <<= 1;
        st.resize(2*s+2);
    }
    void Add(ll pos,ll val,ll x,ll lx,ll rx)
    {
        if (lx>pos || rx<pos)
            return;
        if (lx==rx)
        {
            st[x]=val;
            return;
        }
        ll mid=(lx+rx)/2;
        if (pos<=mid)
            Add(pos,val,2*x,lx,mid);
        else
            Add(pos,val,2*x+1,mid+1,rx);
        st[x]=st[2*x]&st[2*x+1];
    }
    ll Calc(ll l,ll r,ll x,ll lx,ll rx)
    {
        if (lx>r || rx<l)
            return (1<<20)-1;
        if (lx>=l && rx<=r)
            return st[x];
        ll mid=(lx+rx)/2;
        return Calc(l,r,2*x,lx,mid)&Calc(l,r,2*x+1,mid+1,rx);
    }
};
seg_tree S;
int main()
{
    ios::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    cin >> n;
    S.Init();
    for (ll i=1;i<=n;i++)
    {
        cin >> a[i];
        S.Add(i,a[i],1,1,s);
    }
    ll q,t,x,y;
    cin >> q;
    while (q--)
    {
        cin >> t >> x;
        if (t==1)
        {
            cin >> y;
            S.Add(x,y,1,1,s);
            continue;
        }
        ll ans=LLONG_MAX;
        for (ll i=1;i<=x;i++)
        {
            ll l=x,r=n,mid;
            while (l<=r)
            {
                mid=(l+r)/2;
                if (S.Calc(i,mid,1,1,s)&a[x])
                    l=mid+1;
                else
                {
                    r=mid-1;
                    ans=min(ans,mid-i+min(x-i,mid-x));
                }
            }
        }
        if (ans==LLONG_MAX)
            cout << -1 << "\n";
        else
            cout << ans << "\n";
    }
    return 0;
}
/**
7
7 2 2 7 5 4 4
1
2 4
**/